from functools import total_ordering
 
@total_ordering
class Student:
     
    def __init__(self, jméno, známka, věk):
        self.jméno = jméno
        self.známka = známka
        self.věk = věk
     
    def __repr__(self):
        return repr((self.jméno, self.známka, self.věk))
     
    def __eq__(self, jiný_student):
        return self.věk == jiný_student.věk
     
    def __lt__(self, jiný_student):
        return self.věk < jiný_student.věk


studenti = [
    Student('John', 'A', 15),
    Student('Jane', 'B', 12),
    Student('Dave', 'B', 10),
]

print(studenti[0] < studenti[1])    # False
print(studenti[1] < studenti[0])    # True

print(studenti[2] == studenti[0])   # False

print(studenti[0] > studenti[2])    # True

print(studenti[0] >= studenti[2])   # True
